﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using UUN;
using System.Data.SqlClient;

public partial class Admin_NeiRong_ZhuanJi_XiuGai : System.Web.UI.Page
{
    private 访问 访问;
    private new int ID;
    protected void Page_Load(object sender, EventArgs e)
    {
        访问 = new 访问(this.Context);
        访问.开始处理("修改专辑", "网站后台", "修改专辑", new 访问.回调委托(ZhiXing));
        访问.关闭连接();
    }

    private void ZhiXing()
    {
        访问.验证管理员();

        ID = Convert.ToInt32(Request.QueryString["ID"]);
        if (this.IsPostBack)
            保存();
        else
            初始化();
    }

    private void 初始化()
    {
        Hashtable 专辑 = 常用.SQL_获取(new SqlCommand("SELECT * FROM [" + 程序.数据表前缀 + "内容_音乐_专辑] WHERE [ID]=" + ID, 访问.连接));

        if (专辑 == null)
            throw new Exception("专辑不存在");

        ZhuanJiMingChen.Text = Convert.ToString(专辑["专辑名称"]);
        ZhuanJiFengMian.ImageUrl = Convert.ToString(专辑["专辑封面"]);
        ZhuanJiGeShou.Text = Convert.ToString(专辑["专辑歌手"]);
        ZhuanJiJianJie.Text = Convert.ToString(专辑["专辑简介"]);
    }

    private void 保存()
    {
        访问.验证权限("19");
        String 专辑名称 = ZhuanJiMingChen.Text;
        String 专辑歌手 = ZhuanJiGeShou.Text;
        String 专辑简介 = ZhuanJiJianJie.Text;



        if (专辑名称.Length < 1 || 专辑名称.Length > 50)
            throw new Exception("专辑名称的长度只能在1-50之间");
        if (专辑简介.Length < 1 || 专辑简介.Length > 4000)
            throw new Exception("专辑简介的长度只能在1-4000之间");


        SqlCommand 语句 = new SqlCommand("UPDATE [" + 程序.数据表前缀 + "内容_音乐_专辑] SET " +
            "[专辑名称]=@专辑名称," +
            "[专辑歌手]=@专辑歌手," +
            "[专辑简介]=@专辑简介" +
            " WHERE [ID]=" + ID, 访问.连接);
        语句.Parameters.Add("@专辑名称", SqlDbType.NVarChar).Value = 专辑名称;
        语句.Parameters.Add("@专辑歌手", SqlDbType.NVarChar).Value = 专辑歌手;
        语句.Parameters.Add("@专辑简介", SqlDbType.NVarChar).Value = 专辑简介;
        语句.ExecuteNonQuery();


        访问统计_管理记录 记录 = new 访问统计_管理记录(this.Context, 访问.连接);
        记录.记录("修改专辑["+专辑名称+"]", 访问.用户["昵称"].ToString());

        Response.Redirect(Request.QueryString["rurl"]);
    }
}
